% 1. READ DATA
% 2. HP-FILTER DATA
% 3. MD ESTIMATION
% 4. EM ESTIMATION
% 5. DECOMPOSITION

function output_main = fct_IGpaper_estimation_main(DATAinput,MDinput,EMinput);

    %--------------------------------------------------------------------------
    %--------------------------------------------------------------------------
    % 1. READ DATA (text file)
    % structure: 
    %   column 1 - duration of first spell (t1)
    %   column 2 - duration of the second spell (t2)
    %   column 3 - number of workers with (t1,t2)
    %   incomplete spells: T = tmax + 1
      
    T             = DATAinput.T;
    data          = DATAinput.data;
    filename_out  = DATAinput.filename_out;
    lambda_smooth = DATAinput.lambda_smooth;

    Npeople       = sum(data(:,3));
    data_orig     = data;
    
    %--------------------------------------------------------------------------
    %--------------------------------------------------------------------------
    % 2. DATA PROCESSING
    % use data on complete spells
    % symmetrize, run two-dimensional HP-filter
    % OUTPUT: data is organized in three columns: t1, t2, phi
        % t1: the first spell (in weeks), 
        % t2: the second spell in week, 
        % phi: the number of workers with spell (t1,t2) 
    % lambda: smoothing parameter
        
    select = data(:,1)<=T & data(:,2)<=T;
    data_complete = data(select,:);
    out = fct_process_data_for_estimation(data_complete, lambda_smooth);
    
    data_sym    = out.data_sym;
    data_smooth = out.data_smooth;
    
    % compute hazard rate, and values of p1, p2
    paramdata = fct_process_data_p1p2hazard(data, T);    

    % overwrite p1 and p2 if they exist
    % this is used for estimation with artificial data
    if exist('DATAinput.p1')==1
        paramdata.p1 = DATAinput.p1;
    end
    if exist('DATAinput.p2')==1
        paramdata.p2 = DATAinput.p2;
    end
    
    % save output
    paramdata.data_sym    = data_sym;
    paramdata.data_smooth = data_smooth;
    paramdata.data        = data;
    paramdata.lambda_smooth = lambda_smooth;
    paramdata.T = T;
    paramdata.data_orig = data_orig;
    
    %--------------------------------------------------------------------------
    %--------------------------------------------------------------------------
    % 3. MD estimation    
    % Call MD estimation function
    % If Tykhonov_vec is a vector, the entire code stops, otherwise it
    % continues to EM estimation
    
    % data
    %MDinput.data_sym    = data_sym;
    MDinput.data_sym    = data_smooth;
    MDinput.data_smooth = data_smooth;
    
    MDoutput = fct_MD_estimation(MDinput);
    
    % IF MD STEP WAS SUCCESSFUL, CONTINUE
    %if MDoutput.rankdef == 0;
    
        % if  Tykhonov penalty is a vector, the program plots L-curve and stops
        if size(MDinput.lambda_Tykhonov_vec ,2)>1
           return
        end
    
    %--------------------------------------------------------------------------
    %--------------------------------------------------------------------------
    % 4. EM estimation       
    % call EM estimation
    % Data: choose which data should EM fit, can be smoothed or not
    % select data within TL and TU
    %data_EM  = data_sym;          
    data_EM  = data_smooth;
    select =  data_EM(:,1)>=EMinput.TL & data_EM(:,1)<=EMinput.TU ...
            & data_EM(:,2)>=EMinput.TL & data_EM(:,2)<=EMinput.TU;
    EMinput.data_EM = data_EM(select,:);   

    % initial guess
    EMinput.g_vec_MD     = MDoutput.g_pp;
    EMinput.mu_vec_MD    = MDoutput.mu_pp;
    EMinput.sigma_vec_MD = MDoutput.sigma_pp;

    EMoutput = fct_EM_estimation(EMinput);
        
    %--------------------------------------------------------------------------
    %--------------------------------------------------------------------------
    % 5. DISTRIBUTION WITH NEGATIVE ALPHA
        % GPLUS: distribution with only 
        % GBAR, GUSHORT: 
        % GBARW, GUSHORTW
        % GBARP2, GUSHORTP2
        % GBARP2W, GUSHORTP2W
    
    
        GPLUS.g_vec     = EMoutput.g_vec;
        GPLUS.mu_vec    = EMoutput.mu_vec;
        GPLUS.sigma_vec = EMoutput.sigma_vec;
        GPLUS.alpha_beta_vec = GPLUS.mu_vec./GPLUS.sigma_vec.^2 ; 
        GPLUS.K         = length(GPLUS.g_vec);
        FTplus = zeros(GPLUS.K,1);
        FTminus = zeros(GPLUS.K,1);
        for k=1:GPLUS.K
            mu = GPLUS.mu_vec(k);
            sigma = GPLUS.sigma_vec(k);
            FTplus(k,1)  = fct_CDF_F_capped(T,mu,sigma);
            FTminus(k,1) = exp(-2*GPLUS.alpha_beta_vec(k))*FTplus(k,1);        
            FTminus(k,1) = max(0.5*10^(-3), FTminus(k,1));    
        end    
          
        NEGALPHAinput.g_vec_plus     = GPLUS.g_vec ;
        NEGALPHAinput.mu_vec_plus    = GPLUS.mu_vec ;
        NEGALPHAinput.sigma_vec_plus = GPLUS.sigma_vec ;
        NEGALPHAinput.p1             = paramdata.p1_low;
        NEGALPHAinput.p2             = paramdata.p2;
        NEGALPHAinput.TU             = T;
        NEGALPHAinput.lambda1        = 20;
        NEGALPHAinput.lambda2        = 300;
        NEGALPHAinput.lambda3        = 1000;
    
        % lowest p1
        %-----------
        % GBAR: max share of workers that we turn negative
        % GUSHORT: min share of workers that we turn negative
        % GBARW: max share of workers with negative alpha in resulting distribution
        % GUSHORTW: min share of workers with negative alpha in resulting distribution
        NEGALPHAinput.weights = ones(GPLUS.K,1);
        GBAR                  = fct_negative_alpha_LSQ(NEGALPHAinput);
        GUSHORT             = fct_negative_alpha_LSQ_max(NEGALPHAinput);
        if GBAR.check == 0
            NEGALPHAinput.p1 = paramdata.p1_low*1.05;
            GBAR             = fct_negative_alpha_LSQ(NEGALPHAinput);
            NEGALPHAinput.p1 = paramdata.p1_low;
        end
        if GUSHORT.check == 0
            NEGALPHAinput.p1 = paramdata.p1_low*1.05;
            GUSHORT          = fct_negative_alpha_LSQ_max(NEGALPHAinput);
            NEGALPHAinput.p1 = paramdata.p1_low;
        end
        
        NEGALPHAinput.p1             = paramdata.p1_low;
        NEGALPHAinput.lambda0  = 10^(-3);
        NEGALPHAinput.weights = (FTplus./FTminus).^2;
        GBARW                 = fct_negative_alpha_LSQ(NEGALPHAinput);
        GUSHORTW              = fct_negative_alpha_LSQ_max(NEGALPHAinput);
        
        if GBARW.check ==0
            NEGALPHAinput.p1 = paramdata.p1_low*1.05;
            GBARW             = fct_negative_alpha_LSQ(NEGALPHAinput);
            NEGALPHAinput.p1 = paramdata.p1_low;
        end
        if GUSHORTW.check ==0
            NEGALPHAinput.p1 = paramdata.p1_low*1.05;
            GUSHORTW          = fct_negative_alpha_LSQ_max(NEGALPHAinput);
            NEGALPHAinput.p1 = paramdata.p1_low;
        end
        
        % highest p1
        %-----------
        % GBAR2: max share of workers that we turn negative
        % GUSHORT2: min share of workers that we turn negative
        % GBARW2: max share of workers with negative alpha in resulting distribution
        % GUSHORTW2: min share of workers with negative alpha in resulting distribution
        NEGALPHAinput.p1        = min(paramdata.p2,paramdata.p1_up);
        NEGALPHAinput.lambda0   = 1;
        NEGALPHAinput.lambda1   = 20;
        NEGALPHAinput.lambda2   = 300;
        NEGALPHAinput.lambda3   = 1000;
        NEGALPHAinput.weights = ones(GPLUS.K,1);
        GBARP2                  = fct_negative_alpha_LSQ(NEGALPHAinput);
        GUSHORTP2               = fct_negative_alpha_LSQ_max(NEGALPHAinput);
        if GBARP2.check ==0
            NEGALPHAinput.p1  = NEGALPHAinput.p1*0.95;
            GBARP2           = fct_negative_alpha_LSQ(NEGALPHAinput);
            NEGALPHAinput.p1  = min(paramdata.p2,paramdata.p1_up);
        end
        if GUSHORTP2.check == 0
            NEGALPHAinput.p1 = NEGALPHAinput.p1*0.95;
            GUSHORTP2       = fct_negative_alpha_LSQ_max(NEGALPHAinput);
            NEGALPHAinput.p1 = min(paramdata.p2,paramdata.p1_up);
        end
        
        
        NEGALPHAinput.lambda0  = 10^(-3);
        NEGALPHAinput.weights  = (FTplus./FTminus).^2;
        GBARP2W                = fct_negative_alpha_LSQ(NEGALPHAinput);
        GUSHORTP2W             = fct_negative_alpha_LSQ_max(NEGALPHAinput);
        
        if GBARP2W.check ==0
            NEGALPHAinput.p1  = NEGALPHAinput.p1*0.95;
            GBARP2W           = fct_negative_alpha_LSQ(NEGALPHAinput);
            NEGALPHAinput.p1  = min(paramdata.p2,paramdata.p1_up);
        end
        if GUSHORTP2W.check == 0
            NEGALPHAinput.p1 = NEGALPHAinput.p1*0.95;
            GUSHORTP2W       = fct_negative_alpha_LSQ_max(NEGALPHAinput);
            NEGALPHAinput.p1 = min(paramdata.p2,paramdata.p1_up);
        end
        
    %--------------------------------------------------------------------------
    % 6. DECOMPOSITION OF THE HAZARD RATE
    DECOMPinput = GPLUS;
    DECOMPinput.tmin  = 0;
    DECOMPinput.tmax  = 104;
    GPLUSdecomp = fct_decomposition_increments(DECOMPinput);
    
    DECOMPinput = GBAR;
    DECOMPinput.tmin  = 0;
    DECOMPinput.tmax  = 104;
    GBARdecomp = fct_decomposition_increments(DECOMPinput);
    
    DECOMPinput = GUSHORT;
    DECOMPinput.tmin  = 0;
    DECOMPinput.tmax  = 104;
    GUSHORTdecomp = fct_decomposition_increments(DECOMPinput);
    
    DECOMPinput = GBARW;
    DECOMPinput.tmin  = 0;
    DECOMPinput.tmax  = 104;
    GBARWdecomp = fct_decomposition_increments(DECOMPinput);
    
    DECOMPinput = GUSHORTW;
    DECOMPinput.tmin  = 0;
    DECOMPinput.tmax  = 104;
    GUSHORTWdecomp = fct_decomposition_increments(DECOMPinput);
    
    DECOMPinput = GBARP2;
    DECOMPinput.tmin  = 0;
    DECOMPinput.tmax  = 104;
    GBARP2decomp = fct_decomposition_increments(DECOMPinput);
    
    DECOMPinput = GUSHORTP2;
    DECOMPinput.tmin  = 0;
    DECOMPinput.tmax  = 104;
    GUSHORTP2decomp = fct_decomposition_increments(DECOMPinput);
    
    DECOMPinput = GBARP2W;
    DECOMPinput.tmin  = 0;
    DECOMPinput.tmax  = 104;
    GBARP2Wdecomp = fct_decomposition_increments(DECOMPinput);
    
    DECOMPinput = GUSHORTP2W;
    DECOMPinput.tmin  = 0;
    DECOMPinput.tmax  = 104;
    GUSHORTP2Wdecomp = fct_decomposition_increments(DECOMPinput);
    
    %--------------------------------------------------------------------------
    % 7. SAVE EVERYTHING INTO ONE FILE    
    save(filename_out, 'paramdata','EMinput','EMoutput','MDinput','MDoutput',...
    'GPLUS', 'GBAR', 'GUSHORT', 'GBARW', 'GUSHORTW',...
    'GBARdecomp', 'GUSHORTdecomp',...
    'GBARWdecomp', 'GUSHORTWdecomp','GPLUSdecomp',...
    'GBARP2','GUSHORTP2','GBARP2W','GUSHORTP2W',...
    'GBARP2decomp','GUSHORTP2decomp','GBARP2Wdecomp','GUSHORTP2Wdecomp');

    output_main = 1;

return
